<?php
session_start();
 
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
 
/*
|--------------------------------------------------------------------------
| CONFIG
|--------------------------------------------------------------------------
*/
$BASE_URL  = "https://hub.beyondwalls.com/api";
$projectId = $_GET['property_id'] ?? null;
$apiToken  = '1f32c0e545a29bd7350f9d6ba18eafe1fb0b2ece1630092b72262fa43ba4d632';
 
function api($url, $method = 'GET', $data = null)
{
    global $apiToken;
 
    $ch = curl_init($url);
 
    $headers = [
        'Content-Type: application/json',
        'X-API-Token: ' . $apiToken,
    ];
 
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST  => $method,
        CURLOPT_HTTPHEADER     => $headers,
    ]);
 
    if ($data !== null) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }
 
    $res = curl_exec($ch);
    curl_close($ch);
 
    return json_decode($res, true);
}
 
/*
|--------------------------------------------------------------------------
| START CHAT
|--------------------------------------------------------------------------
*/
if (($_GET['action'] ?? '') === 'start') {
 
    $_SESSION = [];
 
    $start = api("$BASE_URL/properties/$projectId/chat/start");
 
    if (empty($start['question'])) {
        echo json_encode(['error' => 'No question returned']);
        exit;
    }
 
    $_SESSION['form_id']     = $start['form_id'];
    $_SESSION['response_id'] = $start['response_id'] ?? null;
    $_SESSION['question']    = $start['question'];
 
    echo json_encode([
        'question' => $start['question']
    ]);
    exit;
}
 
/*
|--------------------------------------------------------------------------
| ANSWER QUESTION
|--------------------------------------------------------------------------
*/
if (($_GET['action'] ?? '') === 'answer') {
 
    // ✅ FIXED SESSION CHECK
    if (!isset($_SESSION['question'])) {
        echo json_encode([
            'finished' => true,
            'message'  => 'Session expired'
        ]);
        exit;
    }
 
    $q = $_SESSION['question'];
 
    // Normalize option_id
    $optionId = null;
    if (isset($_POST['option_id']) && $_POST['option_id'] !== '') {
        $optionId = (int) $_POST['option_id'];
    }
 
    $payload = [
        'form_id'     => $_SESSION['form_id'],
        'question_id' => $q['id'],
        'option_id'   => $optionId,
        'label'       => $_POST['label'] ?? null,
        'answer_text' => $_POST['answer_text'] ?? null,
        'response_id' => $_SESSION['response_id'],
    ];
 
    $next = api(
        "$BASE_URL/properties/$projectId/chat/answer",
        'POST',
        $payload
    );
 
    // END CHAT
    if (!empty($next['finished'])) {
        $_SESSION = [];
        echo json_encode($next);
        exit;
    }
 
    // STORE NEXT QUESTION
    if (!empty($next['next_question'])) {
        $_SESSION['question']    = $next['next_question'];
        $_SESSION['response_id'] = $next['response_id'] ?? $_SESSION['response_id'];
    }
 
    echo json_encode($next);
    exit;
}