(() => {

    const container = document.getElementById('property-chatbot');
    if (!container) return;

    const projectId = container.dataset.property;
    const API_URL = 'https://blog-assets.hub.beyondwalls.com/blog-chat-bot/chatbot.php';

    container.innerHTML = `
    <style>
    #cb-fab {
      position: fixed;
      bottom: 22px;
      right: 22px;
      width: 60px;
      height: 60px;
      background: linear-gradient(135deg,#2563eb,#1e40af);
      border-radius: 50%;
      display:flex;
      align-items:center;
      justify-content:center;
      cursor:pointer;
      box-shadow:0 10px 30px rgba(37,99,235,.4);
      z-index:9999;
      animation:pulse 2s infinite;
    }
    @keyframes pulse {
      0% { box-shadow:0 0 0 0 rgba(37,99,235,.5); }
      70% { box-shadow:0 0 0 15px rgba(37,99,235,0); }
      100% { box-shadow:0 0 0 0 rgba(37,99,235,0); }
    }
     
    #cb-window {
      position: fixed;
      bottom: 90px;
      right: 20px;
      width: 360px;
      height: 540px;
      background:#fff;
      border-radius:16px;
      box-shadow:0 20px 40px rgba(0,0,0,.25);
      display:none;
      flex-direction:column;
      overflow:hidden;
      z-index:9999;
      animation:slideUp .25s ease;
    }
    @keyframes slideUp {
      from { transform:translateY(20px); opacity:0; }
      to { transform:translateY(0); opacity:1; }
    }
     
    #cb-header {
      background:linear-gradient(135deg,#2563eb,#1e40af);
      color:#fff;
      padding:14px;
      display:flex;
      justify-content:space-between;
      align-items:center;
      font-weight:600;
    }
     
    #cb-messages {
      flex:1;
      padding:16px;
      overflow-y:auto;
      background:#f8fafc;
    }
     
    .cb-msg {
      max-width:80%;
      padding:10px 14px;
      margin-bottom:10px;
      border-radius:16px;
      line-height:1.4;
      font-size:14px;
    }
    .cb-bot {
      background:#e5e7eb;
      border-bottom-left-radius:4px;
    }
    .cb-user {
      background:#2563eb;
      color:#fff;
      margin-left:auto;
      border-bottom-right-radius:4px;
    }
     
    #cb-input {
      padding:12px;
      border-top:1px solid #e5e7eb;
      background:#fff;
    }
     
    .cb-option {
      width:100%;
      padding:10px;
      margin-top:8px;
      border-radius:10px;
      border:1px solid #d1d5db;
      background:#fff;
      cursor:pointer;
      transition:.15s;
    }
    .cb-option:hover {
      background:#eff6ff;
      border-color:#2563eb;
    }
     
    input {
      width:100%;
      padding:12px;
      border-radius:10px;
      border:1px solid #d1d5db;
    }
     
    button.send {
      margin-top:8px;
      width:100%;
      padding:12px;
      background:#2563eb;
      color:#fff;
      border:none;
      border-radius:10px;
      font-weight:600;
      cursor:pointer;
    }
     
    .typing {
      font-size:13px;
      opacity:.6;
      margin-bottom:10px;
    }
      #cb-close {
      background: transparent;
      border: none;
      color: #fff;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
    }
     
    #cb-close:hover {
      opacity: 0.85;
    }
     
    </style>
     
    <div id="cb-fab" title="Chat with us">
    <svg width="28" height="28" viewBox="0 0 24 24" fill="none">
    <path d="M21 11.5C21 6.8 16.97 3 12 3C7.03 3 3 6.8 3 11.5C3 14.09 4.43 16.41 6.65 17.9L6 22L10.03 19.99C10.67 20.07 11.33 20.11 12 20.11C16.97 20.11 21 16.3 21 11.5Z" fill="white"/>
    </svg>
    </div>
     
    <div id="cb-window">
      <div id="cb-header">
        Property Assistant
        <button id="cb-close" type="button">Cancel</button>
      </div>
      <div id="cb-messages"></div>
      <div id="cb-input"></div>
    </div>
    `;

    const fab = document.getElementById('cb-fab');
    const win = document.getElementById('cb-window');
    const close = document.getElementById('cb-close');
    const messages = document.getElementById('cb-messages');
    const inputBox = document.getElementById('cb-input');

    fab.onclick = () => {
        win.style.display = 'flex';
        fab.style.display = 'none';
        startChat();
    };
    close.onclick = () => {
        win.style.display = 'none';
        fab.style.display = 'flex';
    };

    function bot(text) {
        const d = document.createElement('div');
        d.className = 'cb-msg cb-bot';
        d.innerText = text;
        messages.appendChild(d);
        messages.scrollTop = messages.scrollHeight;
    }

    function user(text) {
        const d = document.createElement('div');
        d.className = 'cb-msg cb-user';
        d.innerText = text;
        messages.appendChild(d);
        messages.scrollTop = messages.scrollHeight;
    }

    function typing() {
        const t = document.createElement('div');
        t.className = 'typing';
        t.innerText = 'Property Assistant is typing...';
        messages.appendChild(t);
        messages.scrollTop = messages.scrollHeight;
        return t;
    }

    function startChat() {
        messages.innerHTML = '';
        fetch(`${API_URL}?action=start&property_id=${projectId}`)
            .then(r => r.json())
            .then(res => renderQuestion(res.question));
    }

    function renderQuestion(q) {
        const t = typing();
        setTimeout(() => {
            t.remove();
            bot(q.label);
            renderInput(q);
        }, 600);
    }
    function botError(text) {
        const d = document.createElement('div');
        d.className = 'cb-msg cb-bot';
        d.style.background = '#fee2e2';      // light red
        d.style.color = '#991b1b';           // dark red
        d.style.border = '1px solid #fecaca';
        d.innerText = text;
        messages.appendChild(d);
        messages.scrollTop = messages.scrollHeight;
    }

    function renderInput(q) {
        inputBox.innerHTML = '';

        // validation message container
        const error = document.createElement('div');
        error.style.color = '#dc2626';
        error.style.fontSize = '13px';
        error.style.marginTop = '6px';
        error.style.display = 'none';
        error.id = 'cb-error';

        if (['radio', 'select'].includes(q.type)) {
            q.options.forEach(opt => {
                const b = document.createElement('button');
                b.className = 'cb-option';
                b.innerText = opt.label;
                b.onclick = () => sendAnswer(opt.label, opt.id);
                inputBox.appendChild(b);
            });
        }
        else {
            const i = document.createElement('input');
            i.placeholder = 'Type your answer...';


            if (q.type === 'number') {
                i.type = 'tel';
                i.maxLength = 10;
                i.pattern = '[0-9]*';

                i.addEventListener('input', () => {
                    // remove non-numeric characters
                    i.value = i.value.replace(/\D/g, '');

                    // hide error when user starts correcting
                    error.style.display = 'none';
                    error.innerText = '';
                });
            }

            const b = document.createElement('button');
            b.className = 'send';
            b.innerText = 'Send';

            b.onclick = () => {
                const value = i.value.trim();


                if (q.type === 'number') {
                    if (!/^\d{10}$/.test(value)) {
                        error.innerText = 'Please enter a valid 10-digit phone number.';
                        error.style.display = 'block';
                        return;
                    }
                }


                error.style.display = 'none';
                error.innerText = '';

                sendAnswer(value, null);
            };

            inputBox.appendChild(i);
            inputBox.appendChild(b);
            inputBox.appendChild(error);
        }
    }




    function sendAnswer(text, optionId) {
        user(text);
        inputBox.innerHTML = '';

        const fd = new FormData();

        // OPTION BASED QUESTION
        if (optionId !== null && optionId !== undefined) {
            fd.append('option_id', optionId);
            fd.append('answer_text', ''); // backend will fetch label from option
        }
        // TEXT BASED QUESTION
        else {
            fd.append('option_id', '');
            fd.append('answer_text', text);
        }

        fetch(`${API_URL}?action=answer&property_id=${projectId}`, {
            method: 'POST',
            body: fd
        })
            .then(r => r.json())
            .then(res => {
                console.log('CHATBOT ANSWER RESPONSE:', res);

                if (res.finished === true) {
                    bot(res.message || 'Thank you!');
                    return;
                }

                if (!res.next_question) {
                    bot('Thank you! Our team will contact you shortly.');
                    return;
                }

                renderQuestion(res.next_question);
            });
    }


})();

